﻿//////////////////////////////////////////////
// RasterState.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Resources/Resource.h"

#include "../Utils/DxDefinesWrapper.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RasterState : public Resource, public nkExport::Exportable
	{
		public :

			// Getters
			virtual FILL_MODE getFillMode () const = 0 ;
			virtual CULL_MODE getCullMode () const = 0 ;
			virtual bool getFrontCounterClockwise () const = 0 ;
			virtual int getDepthBias () const = 0 ;
			virtual float getDepthBiasClamp () const = 0 ;
			virtual float getSlopeScaledDepthBias () const = 0 ;
			virtual bool getDepthClipEnabled () const = 0 ;
			virtual bool getScissorEnabled () const = 0 ;
			virtual bool getMultiSampleEnabled () const = 0 ;
			virtual bool getAntiAliasedLineEnabled () const = 0 ;
			virtual unsigned int getForcedSampleCount () const = 0 ;
			virtual bool getConservativeRasterizationEnabled () const = 0 ;

			// Setters
			virtual void setFillMode (FILL_MODE value) = 0 ;
			virtual void setCullMode (CULL_MODE value) = 0 ;
			virtual void setFrontCounterClockwise (bool value) = 0 ;
			virtual void setDepthBias (int value) = 0 ;
			virtual void setDepthBiasClamp (float value) = 0 ;
			virtual void setSlopeScaledDepthBias (float value) = 0 ;
			virtual void setDepthClipEnabled (bool value) = 0 ;
			virtual void setScissorEnabled (bool value) = 0 ;
			virtual void setMultiSampleEnabled (bool value) = 0 ;
			virtual void setAntiAliasedLineEnabled (bool value) = 0 ;
			virtual void setForcedSampleCount (unsigned int value) = 0 ;
			virtual void setConservativeRasterizationEnabled (bool value) = 0 ;
			virtual void resetToDefault () = 0 ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<RasterState> create (System* system = nullptr) ;

		protected :

			// Functions
			// Constructor
			RasterState (System* system) noexcept ;
	} ;
}